IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CP_Turno_DesAsignar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CP_Turno_DesAsignar 
END
GO

CREATE PROCEDURE [dbo].[CP_Turno_DesAsignar] (@Id_Turno INT)
AS

DECLARE @Mensaje VARCHAR(100)
DECLARE @Id_Turno_Padre INT
DECLARE @Id_Turno_Borrar INT
DECLARE @Id_Turno_Cli INT
DECLARE @Id_Turno_Tomado INT



BEGIN TRY
BEGIN TRAN

SELECT @Id_Turno_Padre=ISNULL(Id_Turno_Padre,0) from CRM_Turnos WHERE Id_Turno=@Id_Turno 
IF (@Id_Turno_Padre<>0) SET @Id_Turno = @Id_Turno_Padre



DECLARE Turno_BorrarPadre CURSOR FOR  SELECT Id_Turno FROM CRM_Turnos WHERE Id_Turno = @Id_Turno OR Id_Turno_Padre = @Id_Turno
OPEN Turno_BorrarPadre 
FETCH NEXT FROM Turno_BorrarPadre INTO @Id_Turno_Borrar
WHILE @@FETCH_STATUS = 0                     --recorro el grupo de tunos o el turno solo
BEGIN
--------------Borro los clientes------------------------------------------
	DECLARE TurnoBorrarClientes CURSOR FOR SELECT  Id_Turno_Cli,ISNULL(Id_Turno_Tomado, 0) FROM CRM_Turnos_Clientes 
	                           WHERE Id_Turno = @Id_Turno_Borrar

	OPEN TurnoBorrarClientes 
	FETCH NEXT FROM TurnoBorrarClientes INTO @Id_Turno_Cli,@Id_Turno_Tomado
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @Id_Turno_Tomado <> 0 UPDATE CRM_Turnos SET Estado = '', Id_Cliente = 0, Fecha_Asignacion = NULL, Tipo_Reserva ='' , Id_Turno_Padre = 0 WHERE Id_Turno=@Id_Turno_Tomado  --desagino el turno tomado
        DELETE CRM_Turnos_Clientes WHERE Id_Turno_Cli = @Id_Turno_Cli   -- borro turnos clientes
		FETCH NEXT FROM TurnoBorrarClientes INTO @Id_Turno_Cli,@Id_Turno_Tomado
	END
	CLOSE TurnoBorrarClientes
	DEALLOCATE TurnoBorrarClientes
--------------FIN Borro los clientes------------------------------------------
	UPDATE CRM_Turnos SET Estado = '', Id_Cliente = 0, Fecha_Asignacion = NULL, Tipo_Reserva ='', Id_Turno_Padre = 0
	WHERE Id_Turno=@Id_Turno_Borrar
	FETCH NEXT FROM Turno_BorrarPadre INTO @Id_Turno_Borrar
END
CLOSE Turno_BorrarPadre
DEALLOCATE Turno_BorrarPadre

COMMIT
SELECT  0 AS ErrorNumber
		,0 AS ErrorSeverity
		,0 AS ErrorState
		,0 AS ErrorProcedure
		,0 AS ErrorLine
		,@Mensaje AS ErrorMessage

END TRY


BEGIN CATCH
EXECUTE usp_GetErrorInfo;
ROLLBACK
END CATCH;